state:suppress_toolbar_menu();
state:suppress_transport_menu();
state:suppress_interface_hints();

local generator_mirror = resize.location.std.generators[1].mirror:as_rectangled():expand(1);
local checker_mirror = resize.location.std.checkers[1].mirror:as_rectangled():expand(1);
local center_of_top = resize.location.top_area:as_rectangled():center();
local center_of_mid = resize.location.mid_area:as_rectangled():center();
local center_of_bottom = resize.location.bottom_area:as_rectangled():center();
function highlight_path(c, fade)
  draw_arrow_centered(c, c.viewport:world_to_view(center_of_top), 1.9 * c.viewport.zoom, RIGHT, {1, 1, 1, fade.progress * blinking_at_time(fade.total, 1)})
  draw_arrow_centered(c, c.viewport:world_to_view(center_of_mid), 1.9 * c.viewport.zoom, LEFT, {1, 1, 1, fade.progress * blinking_at_time(fade.total, 1)})
  draw_arrow_centered(c, c.viewport:world_to_view(center_of_bottom), 1.9 * c.viewport.zoom, RIGHT, {1, 1, 1, fade.progress * blinking_at_time(fade.total, 1)})
end

local default_vertical = 0.6
set_default_vertical(default_vertical)

local function only_conveyor_interaction(i)
  return i.type == "PlaceBlockAction" and i.block.type == "Conveyor"
end
local function is_conveyor_selected()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialPlaceObject" then
    if partial.what.type == "Conveyor" then
      return true
    end
  end
end
local function is_conveyor_flipped()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialPlaceObject" then
    if partial.what.type == "Conveyor" then
      return partial.orientation == F0
    end
  end
end
local function is_conveyor_flipped_any()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialPlaceObject" then
    if partial.what.type == "Conveyor" then
      return not partial.orientation:is_rotation()
    end
  end
end
local function is_conveyor_flipped_vertically()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialPlaceObject" then
    if partial.what.type == "Conveyor" then
      return partial.orientation == F2
    end
  end
end

local function only_conveyor_interaction(i)
  return i.type == "PlaceBlockAction" and i.block.type == "Conveyor"
end
local function only_allow_flip(i)
  if i.type == "MouseEventAction" then
    return i.event == MouseEventAction.mmb_click
  elseif i.type == "MouseUpdateAction" then
    return i.lmb == MOUSE_NONE
  else
    return i == PlayerInteraction.cancel or i == PlayerInteraction.flip
  end
end
local function allow_any_reorientation(i)
  if i.type == "MouseEventAction" then
    if i.type == MouseEventAction.mmb_click or i.type == MouseEventAction.scroll_up or i.type == MouseEventAction.scroll_down then
      return true
    end
  elseif i.type == "MouseUpdateAction" then
    return i.lmb == MOUSE_NONE
  else
    return i == PlayerInteraction.cancel or i == PlayerInteraction.flip or i == PlayerInteraction.rotate_right or i == PlayerInteraction.rotate_left
  end
end
local function only_place(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.lmb_click or i.type == MouseEventAction.rmb_click then
      return true
    end
  elseif i.type == "MouseUpdateAction" then
    return true
  end
end
function get_remaining_holes(gap)
  local ret = {}
  for v in each_vector(gap) do
    if state.grid:at(v) == nil then
      table.insert(ret, v)
    end
  end
  return ret
end
function indicate_gap(gap)
  return function(c, fade)
    for _, v in pairs(get_remaining_holes(gap)) do
      local rect = c.viewport:world_to_view(Rectangle.new(v, v))
      c:draw_rectangle(
        rect,
        {0.0, 1.0, 0.0, fade.progress * (0.1 + fading_at_time(fade.total) * 0.3)}
      )
      draw_arrow_at_rect(
        c,
        rect,
        0.06 - 0.04 * bouncing_at_time(fade.total),
        c.viewport.zoom * 0.5,
        DOWN,
        {1, 1, 1, fade.progress}
      )
    end
  end
end
local left_conveyors = resize.location.left_conveyors
local function is_top_done()
  return #get_remaining_holes(left_conveyors) == 0
end
local right_conveyors = resize.location.right_conveyors
local function is_bottom_done()
  return #get_remaining_holes(right_conveyors) == 0
end
local function get_missing_joints() --blocks needing joint on right
  local missing = {}
  for v in each_vector(right_conveyors) do
    local block = state.grid:at(v);
    assert(block)
    if not block.connections[RIGHT] then
      table.insert(missing, v)
    end
  end
  return missing
end
function is_joining_done()
  return #get_missing_joints() == 0
end
function is_join_selected()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreateJoint" then
    return true
  end
end
local function only_open_join(i)
  return i.type == "JoinAction";
end
local function only_join_interaction(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.lmb_click or i.type == MouseEventAction.rmb_click then
      return true
    end
  elseif i.type ~= "MouseUpdateAction" then
    return true
  end
end
local function draw_missing_joints(c, fade)
  local color = {1, 1, 0, fade.progress * 0.2 * bouncing_at_time(fade.total)}
  for _, v in pairs(get_missing_joints()) do
    local rect = c.viewport:world_to_view(Rectangled.new(0.4, -0.5, 0.6, 0.5):translate(v:as_vectord()))
    c:draw_rectangle(
      rect,
      color
    )
    draw_arrow_at_rect(
      c,
      rect,
      0.06 - 0.04 * bouncing_at_time(fade.total),
      c.viewport.zoom * 0.5,
      DOWN,
      {1, 1, 1, fade.progress}
    )
  end
end

function tutorial_routine()
  return coroutine.wrap(function()
    if not is_top_done() or not is_bottom_done() or not is_joining_done() then
      embed(ramp(5, do_all(
          announce_lambda("The path here is complicated.", 0.1),
          highlight_path
        ), captured_cancel())
      )
      embed(pause(0.25))
      embed(announce("We need to rotate our conveyors", 3, 0.1, captured_cancel()))
      embed(pause(0.25))
    end
    state:suppress_toolbar_menu(false)
    while not is_top_done() or not is_bottom_done() do
      if not is_conveyor_selected() then
        set_user_input_filter(only_conveyor_interaction)
        embed(ramp_until(is_conveyor_selected, do_all(
          announce_lambda("Tool: Conveyor", 0.2),
          highlight_menu_item_lambda("toolbar_2")
        )))
      elseif not is_top_done() then
        if not is_conveyor_flipped() then
          set_user_input_filter(only_allow_flip)
          embed(ramp_while(
            lifted_and(is_conveyor_selected, lifted_not(is_conveyor_flipped)),
            do_all(
              announce_lambda("Press F to flip", 0.2, default_vertical + 0.15),
              announce_lambda("(Or middle mouse click)", 0.08)
            )
          ))
        else
          set_user_input_filter(lifted_or(only_allow_flip, only_place))
          embed(ramp_while(
            lifted_and(
              is_conveyor_selected,
              is_conveyor_flipped,
              lifted_not(is_top_done)
            ),
            do_all(
              announce_lambda("Click and drag to place.", 0.12),
              indicate_gap(left_conveyors)
            )
          ))
        end
      elseif not is_bottom_done() then
        if not is_conveyor_flipped_vertically() then
          set_user_input_filter(allow_any_reorientation)
          embed(ramp_while(
            lifted_and(is_conveyor_selected, lifted_not(is_conveyor_flipped_any)),
            do_all(
              announce_lambda("Press F to flip", 0.2, default_vertical + 0.15),
              announce_lambda("(Or middle mouse click)", 0.08)
            )
          ))
          embed(ramp_while(
            lifted_and(is_conveyor_selected, is_conveyor_flipped_any, lifted_not(is_conveyor_flipped_vertically)),
            do_all(
              announce_lambda("Press E or R to rotate", 0.15, default_vertical + 0.15),
              announce_lambda("(Or scroll with mouse)", 0.08)
            )
          ))
        else
          set_user_input_filter(lifted_or(allow_any_reorientation, only_place))
          embed(ramp_while(
            lifted_and(
              is_conveyor_selected,
              is_conveyor_flipped_vertically,
              lifted_not(is_bottom_done)
            ),
            do_all(
              announce_lambda("Click and drag to place.", 0.12),
              indicate_gap(right_conveyors)
            )
          ))
        end
      elseif is_conveyor_selected() then
        set_user_input_filter(only_cancel_filter)
        embed(ramp_while(is_conveyor_selected, announce_lambda("Right click to exit conveyor tool", 0.1)))
      elseif not is_joining_done() then
        set_user_input_filter(only_open_join)
        embed(ramp_until(is_join_selected, do_all(
          announce_lambda("Tool: Join", 0.2),
          highlight_menu_item_lambda("toolbar_9")
        )))
        set_user_input_filter(only_join_interaction)
        embed(ramp_while(
          lifted_and(
            is_join_selected,
            lifted_not(is_joining_done)
          ),
          do_all(
            announce_lambda("Click and drag to weld", 0.1),
            draw_missing_joints
          )
        ))
        set_user_input_filter(liftd_or(only_cancel_filter, only_play_or_stop_or_speed_filter))
        embed(ramp_while(is_join_selected, do_all(announce_lambda("Right click to exit join tool", 0.1))))
      else
        break
      end
      embed(pause(0)) --don't crash if I screw up the code :)
    end
    set_user_input_filter(only_cancel_filter)
    embed(ramp_while(is_conveyor_selected, announce_lambda("Right click to exit conveyor tool", 0.1)))
    if not is_joining_done() then
      embed(announce("We need to anchor the ceiling conveyors.", 3, 0.08, captured_cancel()))
      while not is_joining_done() do
        set_user_input_filter(only_open_join)
        embed(ramp_until(is_join_selected, do_all(
          announce_lambda("Tool: Join", 0.2),
          highlight_menu_item_lambda("toolbar_9")
        )))
        set_user_input_filter(only_join_interaction)
        embed(ramp_while(
          lifted_and(
            is_join_selected,
            lifted_not(is_joining_done)
          ),
          do_all(
            announce_lambda("Click and drag to weld", 0.1),
            draw_missing_joints
          )
        ))
      end
      set_user_input_filter(lifted_or(only_cancel_filter, only_play_or_stop_or_speed_filter))
      embed(ramp_while(is_join_selected, do_all(announce_lambda("Right click to exit join tool", 0.1))))
    end
    state:suppress_toolbar_menu()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_or_stop_or_speed_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.15))
    ))
    state:suppress_interface_hints(false)
  end)
end

draw_interpreted_routine(tutorial_routine())

state:filter_interactions(function(i)
  if i.type == "Place" then
    if i.what.type == "Conveyor" then
      if left_conveyors:contains(i.where.position) then
        if i.where.view.object_to_view == F0 then
          return
        else
          return "This conveyor is oriented the wrong way!"
        end
      elseif right_conveyors:contains(i.where.position) then
        if i.where.view.object_to_view == F2 then
          return
        else
          return "This conveyor is oriented the wrong way!"
        end
      else
        return "Cannot place outside of the given area"
      end
    end
  elseif i.type == "Join" then
    return
  end
  return "This level only allows placing conveyors in designated areas."
end)
